#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// fractal experimentMod01.fsh  by   conan777
//https://www.shadertoy.com/view/ltyBRz
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.628318  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//#version 400 core

vec4 orb;

float map(vec3 p, float s)
{
	float scale = 1.0;
	orb = vec4(100.0);

	for (int i = 0; i < 8; i++)
	{
		p = -1.0 + 2.0 * fract(0.5 * p + 0.5);
		float r2 = dot(p, p);
        orb = min(orb, vec4(abs(p), r2));

		float k = s / r2;
		p *= k;
		scale *= k;
	}
	return 0.25 * (abs(p.x) + abs(p.y)) / scale;
}

float trace( in vec3 ro, in vec3 rd, float s )
{
	float maxd = 30.0;
    float t = 0.01;
    for (int i = 0; i < 150; i++)
    {
	    float precis = 0.001 * t;

	    float h = map(ro + rd * t, s);
        if (h < precis || t > maxd)
            break;
        t += h;
    }
    if (t > maxd)
        t = -1.0;
    return t;
}

vec3 calcNormal( in vec3 pos, in float t, in float s )
{
    float precis = 0.001 * t;

    vec2 e = vec2(1.0,-1.0) * precis;
    return normalize(e.xyy * map(pos + e.xyy, s) +
					 e.yyx * map(pos + e.yyx, s) +
					 e.yxy * map(pos + e.yxy, s) +
                     e.xxx * map(pos + e.xxx, s));
}

vec3 render( in vec3 ro, in vec3 rd, in float anim )
{
    vec3 col = vec3(0.0);
    float t = trace(ro, rd, anim);
    if (t > 0.0)
    {
        vec4 tra = orb;
        vec3 pos = ro + t * rd;
        vec3 nor = calcNormal(pos, t, anim);
        vec3  light = vec3(0.5, 0.5, 0.5);
        float key = clamp(dot(light, nor), 0.0, 1.0);
        vec3 brdf = vec3(0.30, 0.20, 0.10) + vec3(1.00, 0.40, 0.00) * key;
        vec3 rgb = vec3(1.0);
        rgb = mix(rgb, vec3(0.90, 0.20, 0.20), clamp(10.0 * tra.y, 0.0, 1.0));
        col = rgb * brdf * exp(-0.2 * t);
    }
    return sqrt(col);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    float t = iTime;
    
    vec2 uv = (fragCoord.xy - iResolution.xy/2.0) / max(iResolution.xy.x, iResolution.xy.y);
 
    float anim = (sin(iTime * 0.2) + 1.0) * 0.6;
    vec3 tot = vec3(0.0);
    vec3 ro;
    ro = vec3(1.0, 5.0, 5.0);
    vec3 tmp = vec3(uv, 1.0);
    vec3 rd = -normalize(tmp);
    tot += render(ro, rd, anim);
	fragColor = vec4(tot, 1.0);
/* }

void mainVR( out vec4 fragColor, in vec2 fragCoord, in vec3 fragRayOri, in vec3 fragRayDir )
{
    float time = iTime*0.25;
    float anim = (sin(iTime * 0.2) + 1.0) * 0.6;

    vec3 col = render( fragRayOri + vec3(0.0,1.0,2.5), fragRayDir, anim);
    fragColor = vec4( col, 1.0 );
*/
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

